CREATE FUNCTION plpgsql_call_handler() RETURNS language_handler AS '$libdir/plpgsql' LANGUAGE C;
CREATE FUNCTION plpgsql_validator(oid) RETURNS void AS '$libdir/plpgsql' LANGUAGE C;
CREATE TRUSTED PROCEDURAL LANGUAGE plpgsql HANDLER plpgsql_call_handler VALIDATOR plpgsql_validator;
CREATE OR REPLACE FUNCTION mc_timestamp_updating() RETURNS TRIGGER AS $timestamp_updating_function$
BEGIN
  NEW._timestamp := now(); -- hack comment
  return NEW; -- hack comment
END; -- hack comment
$timestamp_updating_function$ LANGUAGE plpgsql;
CREATE TABLE change_table (_rowid bigserial PRIMARY KEY, table_name varchar(40) NOT NULL);
CREATE TABLE change_log (_rowid bigserial PRIMARY KEY, _timestamp timestamp with time zone, table_id bigint NOT NULL,primary_key bigint NOT NULL,operation CHAR(1) NOT NULL,changed_columns varchar, client_id varchar(64), user_id bigint);
CREATE INDEX change_log_table_id_index ON change_log (table_id);
CREATE INDEX change_log_primary_key_index ON change_log (primary_key);
CREATE TRIGGER change_log_timestamp_updating BEFORE INSERT OR UPDATE ON change_log FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE AGGREGATE aggarray (basetype = anyelement, sfunc = array_append,stype = anyarray, initcond = '{}' );
CREATE OR REPLACE FUNCTION mc_addmembertoset(character varying, integer)
  RETURNS character varying AS
$BODY$
  DECLARE 	
    existingstring ALIAS FOR $1; -- hack comment
    newvalue ALIAS FOR $2; -- Hack Comment
    tempstring varchar; -- hack comment 	
    sortvalues integer[]; -- Hack Comment
  BEGIN
    IF char_length($1)>0
    THEN
    tempstring := mc_convert_pipes_to_array_string(existingstring); -- Hack Comment
    tempstring := tempstring || ',' || newvalue; -- Hack Comment
    sortvalues := string_to_array(tempstring,','); -- Hack Comment
    tempstring := mc_getpackedstring(sortvalues); -- Hack Comment
    
    RETURN mc_convert_array_string_to_pipes(tempstring); -- Hack Comment
  ELSE
    RETURN '|' || $2 || '|'; -- hack comment 	
  END IF; -- Hack Comment
 END
$BODY$ 
  LANGUAGE 'plpgsql' IMMUTABLE 
  COST 100;
CREATE OR REPLACE FUNCTION mc_removememberfromset(character varying, integer)
  RETURNS character varying AS
$BODY$
	SELECT replace($1,'|' || $2 || '|','')
$BODY$
  LANGUAGE 'sql' IMMUTABLE
  COST 100;
CREATE OR REPLACE FUNCTION mc_convert_array_string_to_pipes(string character varying) 
  RETURNS character varying AS
$BODY$
	SELECT '|' || replace($1,',','||') || '|'
$BODY$ 
  LANGUAGE 'sql' IMMUTABLE
  COST 100;
CREATE OR REPLACE FUNCTION mc_convert_pipes_to_array_string(string character varying)
  RETURNS character varying AS
$BODY$
  SELECT replace(replace($1,'||',','),'|','')
$BODY$
  LANGUAGE 'sql' IMMUTABLE
  COST 100;
CREATE OR REPLACE FUNCTION mc_getpackedstring(anyarray)
  RETURNS character varying AS
$BODY$
    SELECT array_to_string(aggarray(Element),',') FROM (SELECT DISTINCT ($1)[s] as Element FROM
    generate_series(1,array_upper($1, 1)) as s ORDER BY Element) AS Alias; -- Hack Comment
$BODY$
  LANGUAGE 'sql' IMMUTABLE
  COST 100;
CREATE TABLE BEXIgnore (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, foreignAppEntityName varchar, foreignAppImportID varchar, foreignAppName varchar);
CREATE SEQUENCE BEXIgnore_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY BEXIgnore._rowid;
ALTER TABLE BEXIgnore ALTER COLUMN _rowid SET DEFAULT nextval('BEXIgnore_nextPK');
CREATE TRIGGER BEXIgnore_timestamp_updating BEFORE INSERT OR UPDATE ON BEXIgnore FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Category (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, name varchar);
CREATE SEQUENCE Category_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Category._rowid;
ALTER TABLE Category ALTER COLUMN _rowid SET DEFAULT nextval('Category_nextPK');
CREATE TRIGGER Category_timestamp_updating BEFORE INSERT OR UPDATE ON Category FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Client (_timestamp timestamp with time zone, mileageDistance double precision, _rowid bigint PRIMARY KEY NOT NULL, clientNumber varchar, company varchar, createDate timestamp with time zone, email varchar, extra1 varchar, extra2 varchar, extra3 varchar, extra4 varchar, firstName varchar, hourlyRate double precision, isCompany integer, lastName varchar, mileageRate double precision, modifyDate timestamp with time zone, clientCategoryID integer, balanceCached double precision, retainersBalanceCached double precision, unbilledAmountCached double precision, incompleteAmountCached double precision, addressCity varchar, addressStreet varchar, addressState varchar, addressZIP varchar, addressCountry varchar, addressFormatted varchar, clientPhotoID bigint, currentCurrencyID bigint, overdueAmountCached double precision, overdueAmountValidUntilDate timestamp with time zone, consolidatedTaxID bigint, invoiceTemplatePrefID bigint, estimateTemplatePrefID bigint, statementTemplatePrefID bigint, taxNumber varchar, billingIdentityID bigint, prefix varchar, suffix varchar, middleName varchar, nickName varchar, jobTitle varchar, department varchar, formalGreeting varchar);
CREATE INDEX Client_clientCategoryID_index ON Client (clientCategoryID);
CREATE SEQUENCE Client_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Client._rowid;
ALTER TABLE Client ALTER COLUMN _rowid SET DEFAULT nextval('Client_nextPK');
CREATE TRIGGER Client_timestamp_updating BEFORE INSERT OR UPDATE ON Client FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE ConsolidatedTax (_timestamp timestamp with time zone, active integer, atomic integer, _rowid bigint PRIMARY KEY NOT NULL, createDate timestamp with time zone, name varchar, parentConsolidatedTaxID integer);
CREATE INDEX ConsolidatedTax_parentConsolidatedTaxID_index ON ConsolidatedTax (parentConsolidatedTaxID);
CREATE SEQUENCE ConsolidatedTax_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY ConsolidatedTax._rowid;
ALTER TABLE ConsolidatedTax ALTER COLUMN _rowid SET DEFAULT nextval('ConsolidatedTax_nextPK');
CREATE TRIGGER ConsolidatedTax_timestamp_updating BEFORE INSERT OR UPDATE ON ConsolidatedTax FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Estimate (_timestamp timestamp with time zone, billingsFileID integer, comment varchar, compoundSecondaryTax integer, consolidatedTaxID integer, createDate timestamp with time zone, discount double precision, dueDate timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, estimateNumber varchar, markup double precision, modifyDate timestamp with time zone, name varchar, projectID integer, sentDate timestamp with time zone, state integer, subTotal double precision, tax1 double precision, tax1Name varchar, tax2 double precision, tax2Name varchar, useTax1 integer, useTax2 integer, userFileID integer, estimateHtmlID bigint);
CREATE INDEX Estimate_projectID_index ON Estimate (projectID);
CREATE SEQUENCE Estimate_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Estimate._rowid;
ALTER TABLE Estimate ALTER COLUMN _rowid SET DEFAULT nextval('Estimate_nextPK');
CREATE TRIGGER Estimate_timestamp_updating BEFORE INSERT OR UPDATE ON Estimate FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE EstimateSlip (_timestamp timestamp with time zone, categoryID integer, userID integer, comment varchar, compoundSecondaryTax integer, consolidatedTaxID integer, createDate timestamp with time zone, discount double precision, distance double precision, dueDate timestamp with time zone, duration double precision, endDateTime timestamp with time zone, estimateID integer, foreignAppEntityName varchar, foreignAppImportID varchar, foreignAppLastTouchDate timestamp with time zone, foreignAppName varchar, foreignAppUser varchar, markup double precision, mileageType integer, modifyDate timestamp with time zone, name varchar, nature integer, projectID integer, rate double precision, roundTime integer, startDateTime timestamp with time zone, tax1 double precision, tax1Name varchar, tax2 double precision, tax2Name varchar, _rowid bigint PRIMARY KEY NOT NULL, timeSlipRefID integer, total double precision, typeID integer, units double precision, useTax1 integer, useTax2 integer, uuid varchar);
CREATE INDEX EstimateSlip_estimateID_index ON EstimateSlip (estimateID);
CREATE INDEX EstimateSlip_projectID_index ON EstimateSlip (projectID);
CREATE SEQUENCE EstimateSlip_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY EstimateSlip._rowid;
ALTER TABLE EstimateSlip ALTER COLUMN _rowid SET DEFAULT nextval('EstimateSlip_nextPK');
CREATE TRIGGER EstimateSlip_timestamp_updating BEFORE INSERT OR UPDATE ON EstimateSlip FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE ExtraFieldNames (_timestamp timestamp with time zone, extraField1Name varchar, extraField2Name varchar, extraField3Name varchar, extraField4Name varchar, extraField5Name varchar, extraField6Name varchar, extraField7Name varchar, extraField8Name varchar, _rowid bigint PRIMARY KEY NOT NULL, forEntity integer);
CREATE SEQUENCE ExtraFieldNames_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY ExtraFieldNames._rowid;
ALTER TABLE ExtraFieldNames ALTER COLUMN _rowid SET DEFAULT nextval('ExtraFieldNames_nextPK');
CREATE TRIGGER ExtraFieldNames_timestamp_updating BEFORE INSERT OR UPDATE ON ExtraFieldNames FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Invoice (_timestamp timestamp with time zone, billingsFileID integer, comment varchar, compoundSecondaryTax integer, consolidatedTaxID integer, createDate timestamp with time zone, discount double precision, dueDate timestamp with time zone, invoiceDate timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, invoiceNumber varchar, markup double precision, modifyDate timestamp with time zone, name varchar, sentDate timestamp with time zone, state integer, tax1 double precision, tax1Name varchar, tax2 double precision, tax2Name varchar, taxPointDate timestamp with time zone, useTax1 integer, useTax2 integer, userFileID integer, clientID integer, projectID integer, invoiceHtmlID bigint, totalCached double precision);
CREATE INDEX Invoice_clientID_index ON Invoice (clientID);
CREATE SEQUENCE Invoice_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Invoice._rowid;
ALTER TABLE Invoice ALTER COLUMN _rowid SET DEFAULT nextval('Invoice_nextPK');
CREATE TRIGGER Invoice_timestamp_updating BEFORE INSERT OR UPDATE ON Invoice FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Note (_timestamp timestamp with time zone, contents bytea, createDate timestamp with time zone, modifyDate timestamp with time zone, name varchar, _rowid bigint PRIMARY KEY NOT NULL, plainContents varchar, projectID integer);
CREATE INDEX Note_projectID_index ON Note (projectID);
CREATE SEQUENCE Note_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Note._rowid;
ALTER TABLE Note ALTER COLUMN _rowid SET DEFAULT nextval('Note_nextPK');
CREATE TRIGGER Note_timestamp_updating BEFORE INSERT OR UPDATE ON Note FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Payment (_timestamp timestamp with time zone, cachedAppliedAmount double precision, comment varchar, createDate timestamp with time zone, methodID integer, modifyDate timestamp with time zone, name varchar, _rowid bigint PRIMARY KEY NOT NULL, projectID integer, total double precision, clientID integer, baseCurrencyTotal double precision, baseCurrencyManuallyEntered integer);
CREATE INDEX Payment_clientID_index ON Payment (clientID);
CREATE SEQUENCE Payment_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Payment._rowid;
ALTER TABLE Payment ALTER COLUMN _rowid SET DEFAULT nextval('Payment_nextPK');
CREATE TRIGGER Payment_timestamp_updating BEFORE INSERT OR UPDATE ON Payment FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE PaymentInvoiceEntry (_timestamp timestamp with time zone, amountApplied double precision, createDate timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, invoiceID integer, modifyDate timestamp with time zone, paymentID integer);
CREATE INDEX PaymentInvoiceEntry_invoiceID_index ON PaymentInvoiceEntry (invoiceID);
CREATE INDEX PaymentInvoiceEntry_paymentID_index ON PaymentInvoiceEntry (paymentID);
CREATE SEQUENCE PaymentInvoiceEntry_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY PaymentInvoiceEntry._rowid;
ALTER TABLE PaymentInvoiceEntry ALTER COLUMN _rowid SET DEFAULT nextval('PaymentInvoiceEntry_nextPK');
CREATE TRIGGER PaymentInvoiceEntry_timestamp_updating BEFORE INSERT OR UPDATE ON PaymentInvoiceEntry FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE PaymentMethodType (_timestamp timestamp with time zone, name varchar, _rowid bigint PRIMARY KEY NOT NULL, useRetainer integer);
CREATE SEQUENCE PaymentMethodType_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY PaymentMethodType._rowid;
ALTER TABLE PaymentMethodType ALTER COLUMN _rowid SET DEFAULT nextval('PaymentMethodType_nextPK');
CREATE TRIGGER PaymentMethodType_timestamp_updating BEFORE INSERT OR UPDATE ON PaymentMethodType FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Project (_timestamp timestamp with time zone, balance double precision, clientID integer, completeDate timestamp with time zone, createDate timestamp with time zone, discount double precision, dueDate timestamp with time zone, extraField1 varchar, extraField2 varchar, extraField3 varchar, extraField4 varchar, extraField5 varchar, extraField6 varchar, extraField7 varchar, extraField8 varchar, foreignAppEntityName varchar, foreignAppImportID varchar, foreignAppLastTouchDate timestamp with time zone, foreignAppName varchar, foreignAppUser varchar, modifyDate timestamp with time zone, name varchar, nickname varchar, objective varchar, poNumber varchar, projectCode varchar, _rowid bigint PRIMARY KEY NOT NULL, stageID integer, startDate timestamp with time zone, stateID integer, total double precision, useNickname integer, uuid varchar, totalCached double precision, unbilledCached double precision, incompleteCached double precision, estimatePendingCached double precision, durationOfSlipsCached integer, approverID bigint);
CREATE INDEX Project_clientID_index ON Project (clientID);
CREATE SEQUENCE Project_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Project._rowid;
ALTER TABLE Project ALTER COLUMN _rowid SET DEFAULT nextval('Project_nextPK');
CREATE TRIGGER Project_timestamp_updating BEFORE INSERT OR UPDATE ON Project FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE ProjectStage (_timestamp timestamp with time zone, name varchar, _rowid bigint PRIMARY KEY NOT NULL);
CREATE SEQUENCE ProjectStage_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY ProjectStage._rowid;
ALTER TABLE ProjectStage ALTER COLUMN _rowid SET DEFAULT nextval('ProjectStage_nextPK');
CREATE TRIGGER ProjectStage_timestamp_updating BEFORE INSERT OR UPDATE ON ProjectStage FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE ProjectState (_timestamp timestamp with time zone, name varchar, stateCode integer, _rowid bigint PRIMARY KEY NOT NULL);
CREATE SEQUENCE ProjectState_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY ProjectState._rowid;
ALTER TABLE ProjectState ALTER COLUMN _rowid SET DEFAULT nextval('ProjectState_nextPK');
CREATE TRIGGER ProjectState_timestamp_updating BEFORE INSERT OR UPDATE ON ProjectState FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Retainer (_timestamp timestamp with time zone, amountApplied double precision, createDate timestamp with time zone, modifyDate timestamp with time zone, name varchar, projectID integer, _rowid bigint PRIMARY KEY NOT NULL, total double precision, clientID integer, comment varchar, methodID integer, baseCurrencyTotal double precision, baseCurrencyManuallyEntered integer);
CREATE INDEX Retainer_clientID_index ON Retainer (clientID);
CREATE SEQUENCE Retainer_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Retainer._rowid;
ALTER TABLE Retainer ALTER COLUMN _rowid SET DEFAULT nextval('Retainer_nextPK');
CREATE TRIGGER Retainer_timestamp_updating BEFORE INSERT OR UPDATE ON Retainer FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE SlipTemplate (_timestamp timestamp with time zone, categoryID integer, userID integer, comment varchar, consolidatedTaxID integer, discount double precision, markup double precision, name varchar, nature integer, rate double precision, slipName varchar, _rowid bigint PRIMARY KEY NOT NULL, typeID integer, units double precision, useTax1 integer, useTax2 integer, recurringInvoiceID integer);
CREATE SEQUENCE SlipTemplate_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY SlipTemplate._rowid;
ALTER TABLE SlipTemplate ALTER COLUMN _rowid SET DEFAULT nextval('SlipTemplate_nextPK');
CREATE TRIGGER SlipTemplate_timestamp_updating BEFORE INSERT OR UPDATE ON SlipTemplate FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Tax (_timestamp timestamp with time zone, active integer, compound integer, consolidatedTaxID integer, createDate timestamp with time zone, name varchar, orderIndex integer, parentTaxID integer, rate double precision, registrationNum varchar, _rowid bigint PRIMARY KEY NOT NULL);
CREATE INDEX Tax_consolidatedTaxID_index ON Tax (consolidatedTaxID);
CREATE INDEX Tax_parentTaxID_index ON Tax (parentTaxID);
CREATE SEQUENCE Tax_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Tax._rowid;
ALTER TABLE Tax ALTER COLUMN _rowid SET DEFAULT nextval('Tax_nextPK');
CREATE TRIGGER Tax_timestamp_updating BEFORE INSERT OR UPDATE ON Tax FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE TaxConsolidatedTaxEntry (_timestamp timestamp with time zone, consolidatedTaxID integer, orderIndex integer, _rowid bigint PRIMARY KEY NOT NULL, taxID integer);
CREATE INDEX TaxConsolidatedTaxEntry_consolidatedTaxID_index ON TaxConsolidatedTaxEntry (consolidatedTaxID);
CREATE INDEX TaxConsolidatedTaxEntry_taxID_index ON TaxConsolidatedTaxEntry (taxID);
CREATE SEQUENCE TaxConsolidatedTaxEntry_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY TaxConsolidatedTaxEntry._rowid;
ALTER TABLE TaxConsolidatedTaxEntry ALTER COLUMN _rowid SET DEFAULT nextval('TaxConsolidatedTaxEntry_nextPK');
CREATE TRIGGER TaxConsolidatedTaxEntry_timestamp_updating BEFORE INSERT OR UPDATE ON TaxConsolidatedTaxEntry FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE TimeEntry (_timestamp timestamp with time zone, comment varchar, createDate timestamp with time zone, endDateTime timestamp with time zone, foreignAppEntityName varchar, foreignAppImportID varchar, foreignAppLastTouchDate timestamp with time zone, foreignAppName varchar, foreignAppUser varchar, isManual integer, modifyDate timestamp with time zone, startDateTime timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, timeSlipID integer, uuid varchar);
CREATE INDEX TimeEntry_endDateTime_index ON TimeEntry (endDateTime);
CREATE INDEX TimeEntry_startDateTime_index ON TimeEntry (startDateTime);
CREATE INDEX TimeEntry_timeSlipID_index ON TimeEntry (timeSlipID);
CREATE SEQUENCE TimeEntry_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY TimeEntry._rowid;
ALTER TABLE TimeEntry ALTER COLUMN _rowid SET DEFAULT nextval('TimeEntry_nextPK');
CREATE TRIGGER TimeEntry_timestamp_updating BEFORE INSERT OR UPDATE ON TimeEntry FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE TimeSlip (_timestamp timestamp with time zone, activeForTiming integer, categoryID integer, userID integer, comment varchar, compoundSecondaryTax integer, consolidatedTaxID integer, createDate timestamp with time zone, discount double precision, distance double precision, dueDate timestamp with time zone, duration double precision, endDateTime timestamp with time zone, foreignAppEntityName varchar, foreignAppImportID varchar, foreignAppLastTouchDate timestamp with time zone, foreignAppName varchar, foreignAppUser varchar, iCalUID varchar, invoiceID integer, invoicedDate timestamp with time zone, markup double precision, mileageType integer, modifyDate timestamp with time zone, name varchar, nature integer, projectID integer, rate double precision, roundTime integer, startDateTime timestamp with time zone, tax1 double precision, tax1Name varchar, tax2 double precision, tax2Name varchar, _rowid bigint PRIMARY KEY NOT NULL, timeSlipRefID integer, total double precision, typeID integer, units double precision, useTax1 integer, useTax2 integer, uuid varchar, invoicedProjectID integer, totalCached double precision, durationCached integer, geoLocationStart varchar(512), geoLocationEnd varchar(512), workflowState integer DEFAULT '0', approvedByUserID bigint, approvedDate timestamp with time zone, extra1 varchar, extra2 varchar, extra3 varchar, extra4 varchar);
CREATE INDEX TimeSlip_invoiceID_index ON TimeSlip (invoiceID);
CREATE INDEX TimeSlip_projectID_index ON TimeSlip (projectID);
CREATE INDEX TimeSlip_invoicedProjectID_index ON TimeSlip (invoicedProjectID);
CREATE SEQUENCE TimeSlip_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY TimeSlip._rowid;
ALTER TABLE TimeSlip ALTER COLUMN _rowid SET DEFAULT nextval('TimeSlip_nextPK');
CREATE TRIGGER TimeSlip_timestamp_updating BEFORE INSERT OR UPDATE ON TimeSlip FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE TimeSlipType (_timestamp timestamp with time zone, typeCode integer, _rowid bigint PRIMARY KEY NOT NULL);
CREATE SEQUENCE TimeSlipType_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY TimeSlipType._rowid;
ALTER TABLE TimeSlipType ALTER COLUMN _rowid SET DEFAULT nextval('TimeSlipType_nextPK');
CREATE TRIGGER TimeSlipType_timestamp_updating BEFORE INSERT OR UPDATE ON TimeSlipType FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE URLReference (_timestamp timestamp with time zone, createDate timestamp with time zone, kind integer, modifyDate timestamp with time zone, name varchar, projectID integer, url bytea, _rowid bigint PRIMARY KEY NOT NULL, urlType integer, fileStorageID bigint);
CREATE INDEX URLReference_projectID_index ON URLReference (projectID);
CREATE SEQUENCE URLReference_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY URLReference._rowid;
ALTER TABLE URLReference ALTER COLUMN _rowid SET DEFAULT nextval('URLReference_nextPK');
CREATE TRIGGER URLReference_timestamp_updating BEFORE INSERT OR UPDATE ON URLReference FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE BIUser (_timestamp timestamp with time zone, createDate timestamp with time zone, name varchar, modifyDate timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, active integer NOT NULL DEFAULT '0', password varchar(128), canUseBillingsPro integer, canUseBillingsProTouch integer, canUsePunchcard integer, capability4 integer, capability5 integer, capability6 integer, capability7 integer, capability8 integer);
CREATE SEQUENCE BIUser_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY BIUser._rowid;
ALTER TABLE BIUser ALTER COLUMN _rowid SET DEFAULT nextval('BIUser_nextPK');
CREATE TRIGGER BIUser_timestamp_updating BEFORE INSERT OR UPDATE ON BIUser FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE MCUserDefaultsStorage (_timestamp timestamp with time zone, BlobValue bytea, HostID varchar, Key varchar, LastType integer, _rowid bigint PRIMARY KEY NOT NULL, Value varchar);
CREATE SEQUENCE MCUserDefaultsStorage_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY MCUserDefaultsStorage._rowid;
ALTER TABLE MCUserDefaultsStorage ALTER COLUMN _rowid SET DEFAULT nextval('MCUserDefaultsStorage_nextPK');
CREATE TRIGGER MCUserDefaultsStorage_timestamp_updating BEFORE INSERT OR UPDATE ON MCUserDefaultsStorage FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Statement (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, clientID integer, billingsFileID integer, userFileID integer, sentDate timestamp with time zone, comment varchar, fromDate timestamp with time zone, toDate timestamp with time zone, totalBalance double precision, currentDue double precision, overdue30Days double precision, overdue60Days double precision, overdue90Days double precision, overdueOver90Days double precision, statementNumber varchar);
CREATE INDEX Statement_clientID_index ON Statement (clientID);
CREATE SEQUENCE Statement_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Statement._rowid;
ALTER TABLE Statement ALTER COLUMN _rowid SET DEFAULT nextval('Statement_nextPK');
CREATE TRIGGER Statement_timestamp_updating BEFORE INSERT OR UPDATE ON Statement FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE ClientCategory (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, name varchar, collapsed integer, orderNumber integer);
CREATE SEQUENCE ClientCategory_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY ClientCategory._rowid;
ALTER TABLE ClientCategory ALTER COLUMN _rowid SET DEFAULT nextval('ClientCategory_nextPK');
CREATE TRIGGER ClientCategory_timestamp_updating BEFORE INSERT OR UPDATE ON ClientCategory FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE RecurringInvoice (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, clientID integer, lastSentDate timestamp with time zone, nextSendDate timestamp with time zone, modifyDate timestamp with time zone, recurMonths integer, recurDay integer, templatePath varchar, name varchar, lastPlannedSendDate timestamp with time zone, includeUnbilled integer);
CREATE INDEX RecurringInvoice_clientID_index ON RecurringInvoice (clientID);
CREATE SEQUENCE RecurringInvoice_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY RecurringInvoice._rowid;
ALTER TABLE RecurringInvoice ALTER COLUMN _rowid SET DEFAULT nextval('RecurringInvoice_nextPK');
CREATE TRIGGER RecurringInvoice_timestamp_updating BEFORE INSERT OR UPDATE ON RecurringInvoice FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE ProFormaInvoice (_timestamp timestamp with time zone, billingsFileID integer, comment varchar, createDate timestamp with time zone, dueDate timestamp with time zone, invoiceDate timestamp with time zone, modifyDate timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, clientID integer, userFileID integer, name varchar, slipList varchar, templatePath varchar, total double precision, retainerAmountApplied double precision, customizationValues varchar, templatePreferenceID bigint);
CREATE INDEX ProFormaInvoice_clientID_index ON ProFormaInvoice (clientID);
CREATE SEQUENCE ProFormaInvoice_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY ProFormaInvoice._rowid;
ALTER TABLE ProFormaInvoice ALTER COLUMN _rowid SET DEFAULT nextval('ProFormaInvoice_nextPK');
CREATE TRIGGER ProFormaInvoice_timestamp_updating BEFORE INSERT OR UPDATE ON ProFormaInvoice FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE ClientABLink (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, clientID bigint, deviceUUID varchar, abUUID varchar, abAddressUUID varchar, abEmailUUID varchar);
CREATE INDEX ClientABLink_clientID_index ON ClientABLink (clientID);
CREATE INDEX ClientABLink_deviceUUID_index ON ClientABLink (deviceUUID);
CREATE INDEX ClientABLink_abUUID_index ON ClientABLink (abUUID);
CREATE SEQUENCE ClientABLink_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY ClientABLink._rowid;
ALTER TABLE ClientABLink ALTER COLUMN _rowid SET DEFAULT nextval('ClientABLink_nextPK');
CREATE TRIGGER ClientABLink_timestamp_updating BEFORE INSERT OR UPDATE ON ClientABLink FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE ClientPhoto (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, imageData bytea);
CREATE SEQUENCE ClientPhoto_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY ClientPhoto._rowid;
ALTER TABLE ClientPhoto ALTER COLUMN _rowid SET DEFAULT nextval('ClientPhoto_nextPK');
CREATE TRIGGER ClientPhoto_timestamp_updating BEFORE INSERT OR UPDATE ON ClientPhoto FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE SlipConflict (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, originalSlipID bigint, duplicateSlipID bigint);
CREATE SEQUENCE SlipConflict_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY SlipConflict._rowid;
ALTER TABLE SlipConflict ALTER COLUMN _rowid SET DEFAULT nextval('SlipConflict_nextPK');
CREATE TRIGGER SlipConflict_timestamp_updating BEFORE INSERT OR UPDATE ON SlipConflict FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE DatabaseConfiguration (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, schemaNumber integer, databaseUUID varchar(128), databaseType integer NOT NULL DEFAULT '0', primaryKeyOffset integer NOT NULL, lastUsedReplicationOffset integer NOT NULL DEFAULT '0');
CREATE SEQUENCE DatabaseConfiguration_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY DatabaseConfiguration._rowid;
ALTER TABLE DatabaseConfiguration ALTER COLUMN _rowid SET DEFAULT nextval('DatabaseConfiguration_nextPK');
CREATE TRIGGER DatabaseConfiguration_timestamp_updating BEFORE INSERT OR UPDATE ON DatabaseConfiguration FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE InvoiceHtml (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, html varchar, type integer);
CREATE SEQUENCE InvoiceHtml_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY InvoiceHtml._rowid;
ALTER TABLE InvoiceHtml ALTER COLUMN _rowid SET DEFAULT nextval('InvoiceHtml_nextPK');
CREATE TRIGGER InvoiceHtml_timestamp_updating BEFORE INSERT OR UPDATE ON InvoiceHtml FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Currency (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, name varchar(128), currencyCode varchar(8), currencySymbol varchar(4), exchangeRateToBase double precision DEFAULT '1', exchangeRateDate timestamp with time zone, isBaseCurrency integer DEFAULT '0', active integer DEFAULT '1', localeIdentifier varchar(64), overrideLocaleIdentifier varchar(64), extra1 varchar(1024), extra2 varchar(1024), extra3 varchar(1024), extra4 varchar(1024));
CREATE SEQUENCE Currency_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Currency._rowid;
ALTER TABLE Currency ALTER COLUMN _rowid SET DEFAULT nextval('Currency_nextPK');
CREATE TRIGGER Currency_timestamp_updating BEFORE INSERT OR UPDATE ON Currency FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE EstimateHtml (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, html varchar, type integer);
CREATE SEQUENCE EstimateHtml_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY EstimateHtml._rowid;
ALTER TABLE EstimateHtml ALTER COLUMN _rowid SET DEFAULT nextval('EstimateHtml_nextPK');
CREATE TRIGGER EstimateHtml_timestamp_updating BEFORE INSERT OR UPDATE ON EstimateHtml FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Extra (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, mimeType varchar(64), mimeSubtype varchar(256), internalType integer, name varchar(128), dataValue bytea, stringValue varchar, datetimeValue timestamp with time zone, doubleValue double precision, floatValue double precision, intValue integer, parentEntity varchar(128), parentID bigint);
CREATE SEQUENCE Extra_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Extra._rowid;
ALTER TABLE Extra ALTER COLUMN _rowid SET DEFAULT nextval('Extra_nextPK');
CREATE TRIGGER Extra_timestamp_updating BEFORE INSERT OR UPDATE ON Extra FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE DatabaseReplicant (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, date timestamp with time zone, replicantPrimaryMACAddress varchar(255), replicationKey integer NOT NULL DEFAULT '0', userID bigint, clientUUID varchar(255), lastChangeLogID bigint, lastImportedChangeSetUUID varchar(255), lastExportedChangeSetUUID varchar(255), lastSyncDate timestamp with time zone, replicantType integer NOT NULL DEFAULT '0', replicantName varchar(1024), statusCode integer NOT NULL DEFAULT '0', offlineCloneDate timestamp with time zone);
CREATE SEQUENCE DatabaseReplicant_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY DatabaseReplicant._rowid;
ALTER TABLE DatabaseReplicant ALTER COLUMN _rowid SET DEFAULT nextval('DatabaseReplicant_nextPK');
CREATE TRIGGER DatabaseReplicant_timestamp_updating BEFORE INSERT OR UPDATE ON DatabaseReplicant FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE OfflineConfiguration (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, lastImportedChangeSetUUID varchar, lastExportedChangeSetUUID varchar, lastSyncDate timestamp with time zone, masterName varchar, masterHostAddress varchar, masterAlternateHostAddress varchar, masterHostPort integer, masterAlternateHostPort integer, isActive integer NOT NULL DEFAULT '0', statusCode integer NOT NULL DEFAULT '0', fud timestamp with time zone, offlineUUID varchar(40), cloudAccount varchar(256));
CREATE SEQUENCE OfflineConfiguration_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY OfflineConfiguration._rowid;
ALTER TABLE OfflineConfiguration ALTER COLUMN _rowid SET DEFAULT nextval('OfflineConfiguration_nextPK');
CREATE TRIGGER OfflineConfiguration_timestamp_updating BEFORE INSERT OR UPDATE ON OfflineConfiguration FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE ReportTemplate (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, templateData bytea, name varchar(128), behaviors varchar(512), createDate timestamp with time zone, entityName varchar(128), modifyDate timestamp with time zone, isActiveCode integer, version integer, thumbnailData bytea, thumbnailType varchar(64));
CREATE SEQUENCE ReportTemplate_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY ReportTemplate._rowid;
ALTER TABLE ReportTemplate ALTER COLUMN _rowid SET DEFAULT nextval('ReportTemplate_nextPK');
CREATE TRIGGER ReportTemplate_timestamp_updating BEFORE INSERT OR UPDATE ON ReportTemplate FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE ProjectUser (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, userID bigint NOT NULL, projectID bigint NOT NULL, createDate timestamp with time zone, modifyDate timestamp with time zone, hourlyRate double precision, mileageRate double precision);
CREATE SEQUENCE ProjectUser_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY ProjectUser._rowid;
ALTER TABLE ProjectUser ALTER COLUMN _rowid SET DEFAULT nextval('ProjectUser_nextPK');
CREATE TRIGGER ProjectUser_timestamp_updating BEFORE INSERT OR UPDATE ON ProjectUser FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE FileStorage (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, data bytea);
CREATE SEQUENCE FileStorage_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY FileStorage._rowid;
ALTER TABLE FileStorage ALTER COLUMN _rowid SET DEFAULT nextval('FileStorage_nextPK');
CREATE TRIGGER FileStorage_timestamp_updating BEFORE INSERT OR UPDATE ON FileStorage FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE ReportTemplatePreference (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, templateName varchar(1024), reportTemplateID bigint, configuration bytea);
CREATE SEQUENCE ReportTemplatePreference_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY ReportTemplatePreference._rowid;
ALTER TABLE ReportTemplatePreference ALTER COLUMN _rowid SET DEFAULT nextval('ReportTemplatePreference_nextPK');
CREATE TRIGGER ReportTemplatePreference_timestamp_updating BEFORE INSERT OR UPDATE ON ReportTemplatePreference FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE Identity (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, logo bytea, logoType varchar, line1 varchar, line2 varchar, line3 varchar, line4 varchar, bankAccount varchar, bankIdentifier varchar, bankName varchar, bankAddress varchar, IBAN varchar, BIC varchar, extra1 varchar, extra2 varchar, extra3 varchar, extra4 varchar);
CREATE SEQUENCE Identity_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY Identity._rowid;
ALTER TABLE Identity ALTER COLUMN _rowid SET DEFAULT nextval('Identity_nextPK');
CREATE TRIGGER Identity_timestamp_updating BEFORE INSERT OR UPDATE ON Identity FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
CREATE TABLE ConnectorMap (_timestamp timestamp with time zone, _rowid bigint PRIMARY KEY NOT NULL, foreignID varchar, foreignEntityType varchar, foreignDatabase varchar, foreignAppName varchar, parentID bigint, parentEntity varchar, createDate timestamp with time zone, modifyDate timestamp with time zone, lastPushDate timestamp with time zone, lastPullDate timestamp with time zone, userID bigint);
CREATE INDEX ConnectorMap_parentID_index ON ConnectorMap (parentID);
CREATE SEQUENCE ConnectorMap_nextPK INCREMENT BY 1000 MINVALUE 1 NO MAXVALUE START WITH 1000 NO CYCLE OWNED BY ConnectorMap._rowid;
ALTER TABLE ConnectorMap ALTER COLUMN _rowid SET DEFAULT nextval('ConnectorMap_nextPK');
CREATE TRIGGER ConnectorMap_timestamp_updating BEFORE INSERT OR UPDATE ON ConnectorMap FOR EACH ROW EXECUTE PROCEDURE mc_timestamp_updating();
